/* $Id$ */

/* SUMMARY
 *
 * callmethod.c - callmethod
 *
 * The program callmethod contacts a PJVM manager which in turn
 * contacts the specific JVM requested on the command line, and then
 * attempts to call the method specified and return the result,
 * optionally storing the result as an object.
 *
 *
 * REVISION HISTORY
 * $Log$
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define LINELEN 128
#define BUFSIZE 4096
#define MAX_JVMS 10000 /* change with max JVM count */
#define TRUE 1
#define FALSE 0

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - call method
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1 ], service[ LINELEN + 1 ], buf[ LINELEN + 1 ],
        largebuf[ BUFSIZE + 1 ];
   int jvm_number = MAX_JVMS + 1, class_number, class_selected = FALSE,
       method_number, method_selected = FALSE,
       object_number, object_selected = FALSE, s, c, n,
       remaining_space, garbage_collected = FALSE, 
       static_method = FALSE, call_finalizer = FALSE,
       declared_method = FALSE;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error messages */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:j:c:m:o:gftd" )) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case 'j': if ( strlen( optarg ) != 0 )
                      jvm_number = atoi( optarg );
                   break;
         case 'c': if ( strlen( optarg ) != 0 )
                   {
                      class_selected = TRUE;
                      class_number = atoi( optarg );
                   }
                   break;
         case 'm': if ( strlen( optarg ) != 0 )
                   {
                      method_selected = TRUE;
                      method_number = atoi( optarg );
                   }
                   break;
         case 'o': if ( strlen( optarg ) != 0 )
                   {
                      object_selected = TRUE;
                      object_number = atoi( optarg );
                   }
                   break;
         case 't': static_method = TRUE;
                   break;
         case 'g': garbage_collected = TRUE;
                   break;
         case 'f': call_finalizer = TRUE;
                   break;
         case 'd': declared_method = TRUE;
                   break;
         case '?': errexit( "Usage: callmethod [-h hostname] "
                            "[-s service] [-g] [-f] [-s] -j JVM number "
                            "-c class number -m method number "
                            "[-o object number] "
                            "-- arguments\n"
                            "See manpage for details.\n" );
      }
   }

   if ( jvm_number == ( MAX_JVMS + 1 ) )
      errexit( "Failed: You must select a JVM.\n" );

   if ( class_selected == FALSE )
      errexit( "Failed: You must select a class number.\n" );

   if ( method_selected == FALSE )
      errexit( "Failed: You must select a method number.\n" );

   if ( object_selected == FALSE )
      if ( static_method == FALSE )
         errexit( "Failed: You have selected an instance method, and "
                  "must specify an object to act upon.\n" );

   s = connectTCP( host, service );

   if ( static_method == TRUE )
      sprintf( buf, "clm %d %d %d %d %d %d %d", jvm_number, 
                                             class_number,
                                             method_number,
                                             static_method,
                                             declared_method,
                                             garbage_collected,
                                             call_finalizer );
   else
      sprintf( buf, "clm %d %d %d %d %d %d %d %d", jvm_number,
                                                class_number,
                                                method_number,
                                                static_method,
                                                object_number,
                                                declared_method,
                                                garbage_collected,
                                                call_finalizer );
   ( void ) write( s, buf, LINELEN );

   for ( c = 0; c < LINELEN; c += n )
   {
      n = read( s, buf, LINELEN );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == -10000 )
      errexit( "Failed: Invalid JVM number selected.\n" );

   if ( atoi( buf ) == -20000 )
      errexit( "Failed: Invalid class number selected.\n" );

   if ( atoi( buf ) == -30000 )
      errexit( "Failed: Invalid method number selected.\n" );

   if ( atoi( buf ) == -35000 )
      errexit( "Failed: Invalid object number selected.\n" );

   /* send parameters */

   remaining_space = BUFSIZE;
   strcpy( largebuf, "" );

   for ( c = optind; c < argc; c++ )
   {
      snprintf( buf, LINELEN, "%s ", argv[ c ] );
      strncat( largebuf, buf, remaining_space );

      remaining_space -= strlen( buf );
   }

   ( void ) write( s, largebuf, BUFSIZE );

   for ( c = 0; c < LINELEN; c+= n )
   {
      n = read( s, buf, LINELEN );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == -40000 )
      errexit( "Failed: No parameters sent.\n" );

   if ( atoi( buf ) == -50000 )
      errexit( "Failed: Did not specify parameter type.\n" );

   if ( atoi( buf ) == -60000 )
      errexit( "Failed: Specified Byte but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -70000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Byte.\n" );

   if ( atoi( buf ) == -80000 )
      errexit( "Failed: Specified Boolean but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -90000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Boolean.\n" 
             );

   if ( atoi( buf ) == -100000 )
      errexit( "Failed: Specified character but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -110000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Character.\n"
             );

   if ( atoi( buf ) == -120000 )
      errexit( "Failed: Specified Short but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -130000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Short.\n" );

   if ( atoi( buf ) == -140000 )
      errexit( "Failed: Specified int but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -150000 )
      errexit( "Failed: Java could not convert the argument into an "
               "Integer.\n" 
             );

   if ( atoi( buf ) == -160000 )
      errexit( "Failed: Specified Long but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -170000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Long.\n" );

   if ( atoi( buf ) == -180000 )
      errexit( "Failed: Specified Float but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -190000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Float.\n" );

   if ( atoi( buf ) == -200000 )
      errexit( "Failed: Specified Double but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -210000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Double.\n" );

   if ( atoi( buf ) == -220000 )
      errexit( "Failed: You entered too few parameters.\n" );

   if ( atoi( buf ) == -230000 )
      errexit( "Failed: Invalid object number selected.\n" );

   if ( atoi( buf ) == -240000 )
      errexit( "Failed: Could not retrieve desired object.\n" );

   if ( atoi( buf ) == -250000 )
      errexit( "Failed: Object creation failed.\n" );

   if ( atoi( buf ) == -260000 )
      errexit( "Failed: Specified String but did not provide parameter."
               "\n" );

   if ( atoi( buf ) == -270000 )
      errexit( "Failed: Java could not convert the argument into a "
               "String.\n" );

   if ( atoi( buf ) == -280000 )
      errexit( "Failed: Could not find pre-loaded Object.\n" );

   else
      printf( "Succeeded:  %d\n", atoi( buf ) );

    return 0;
}
