/* $Id: instantiate.c,v 1.5 2001/12/06 16:07:59 eric Exp $ */

/* SUMMARY
 *
 * instantiate.c - instantiate
 *
 * The program instantiate contacts a PJVM manager which in turn
 * contacts the specific JVM requested on the command line, and then
 * attempts to instantiate the class specified and store it internally
 * as an object.
 *
 *
 * REVISION HISTORY
 * $Log: instantiate.c,v $
 * Revision 1.5  2001/12/06 16:07:59  eric
 * Removed extraneous debugging messages.
 *
 * Revision 1.4  2001/12/03 17:14:24  eric
 * Added support for objects and command-line instantiation, corrected
 * erroneous error reporting.
 *
 * Revision 1.3  2001/11/19 17:09:17  eric
 * Added further error/debugging output on failure to instantiate object.
 * Fixed inaccurate detection of parameters
 * Added support for strings on command line
 *
 * Revision 1.2  2001/11/14 18:20:24  eric
 * Corrected spelling error in output
 *
 * Revision 1.1  2001/11/14 18:14:55  eric
 * Initial revision
 *
 *
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define LINELEN 128
#define BUFSIZE 4096
#define MAX_JVMS 10000 /* change with max JVM count */
#define TRUE 1
#define FALSE 0

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - instantiate loaded class
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1 ], service[ LINELEN + 1 ], buf[ LINELEN + 1 ],
        largebuf[ BUFSIZE + 1 ];
   int jvm_number = MAX_JVMS + 1, class_number, class_selected = FALSE,
       constructor_number, constructor_selected = FALSE, s, c, n,
       remaining_space, garbage_collected = FALSE,
       call_finalizer = FALSE;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error messages */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:j:c:o:gf" )) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case 'j': if ( strlen( optarg ) != 0 )
                      jvm_number = atoi( optarg );
                   break;
         case 'c': if ( strlen( optarg ) != 0 )
                   {
                      class_selected = TRUE;
                      class_number = atoi( optarg );
                   }
                   break;
         case 'o': if ( strlen( optarg ) != 0 )
                   {
                      constructor_selected = TRUE;
                      constructor_number = atoi( optarg );
                   }
                   break;
         case 'g': garbage_collected = TRUE;
                   break;
         case 'f': call_finalizer = TRUE;
                   break;
         case '?': errexit( "Usage: instantiate [-h hostname] "
                            "[-s service] [-g] [-f] -j JVM number "
                            "-c class number -o constructor number "
                            "-- arguments\n"
                            "See manpage for details.\n" );
      }
   }

   if ( jvm_number == ( MAX_JVMS + 1 ) )
      errexit( "Failed: You must select a JVM.\n" );

   if ( class_selected == FALSE )
      errexit( "Failed: You must select a class number.\n" );

   if ( constructor_selected == FALSE )
      errexit( "Failed: You must select a constructor number.\n" );

   s = connectTCP( host, service );

   sprintf( buf, "ins %d %d %d %d %d", jvm_number, class_number,
                                             constructor_number,
                                             garbage_collected,
                                             call_finalizer );

   ( void ) write( s, buf, LINELEN );

   for ( c = 0; c < LINELEN; c += n )
   {
      n = read( s, buf, LINELEN );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == -10000 )
      errexit( "Failed: Invalid JVM number selected.\n" );

   if ( atoi( buf ) == -20000 )
      errexit( "Failed: Invalid class number selected.\n" );

   if ( atoi( buf ) == -30000 )
      errexit( "Failed: Invalid constructor number selected.\n" );

   /* send parameters */

   remaining_space = BUFSIZE;
   strcpy( largebuf, "" );

   for ( c = optind; c < argc; c++ )
   {
      snprintf( buf, LINELEN, "%s ", argv[ c ] );
      strncat( largebuf, buf, remaining_space );

      remaining_space -= strlen( buf );
   }

   ( void ) write( s, largebuf, BUFSIZE );

   for ( c = 0; c < LINELEN; c+= n )
   {
      n = read( s, buf, LINELEN );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == -40000 )
      errexit( "Failed: No parameters sent.\n" );

   if ( atoi( buf ) == -50000 )
      errexit( "Failed: Did not specify parameter type.\n" );

   if ( atoi( buf ) == -60000 )
      errexit( "Failed: Specified Byte but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -70000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Byte.\n" );

   if ( atoi( buf ) == -80000 )
      errexit( "Failed: Specified Boolean but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -90000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Boolean.\n" 
             );

   if ( atoi( buf ) == -100000 )
      errexit( "Failed: Specified character but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -110000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Character.\n"
             );

   if ( atoi( buf ) == -120000 )
      errexit( "Failed: Specified Short but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -130000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Short.\n" );

   if ( atoi( buf ) == -140000 )
      errexit( "Failed: Specified int but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -150000 )
      errexit( "Failed: Java could not convert the argument into an "
               "Integer.\n" 
             );

   if ( atoi( buf ) == -160000 )
      errexit( "Failed: Specified Long but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -170000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Long.\n" );

   if ( atoi( buf ) == -180000 )
      errexit( "Failed: Specified Float but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -190000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Float.\n" );

   if ( atoi( buf ) == -200000 )
      errexit( "Failed: Specified Double but did not provide "
               "parameter.\n" );

   if ( atoi( buf ) == -210000 )
      errexit( "Failed: Java could not convert the argument into a "
               "Double.\n" );

   if ( atoi( buf ) == -220000 )
      errexit( "Failed: You entered too few parameters.\n" );

   if ( atoi( buf ) == -230000 )
      errexit( "Failed: Invalid object number selected.\n" );

   if ( atoi( buf ) == -240000 )
      errexit( "Failed: Could not retrieve desired object.\n" );

   if ( atoi( buf ) == -250000 )
      errexit( "Failed: Object creation failed.\n" );

   if ( atoi( buf ) == -260000 )
      errexit( "Failed: Specified String but did not provide parameter."
               "\n" );

   if ( atoi( buf ) == -270000 )
      errexit( "Failed: Java could not convert the argument into a "
               "String.\n" );

   if ( atoi( buf ) == -280000 )
      errexit( "Failed: Could not find pre-loaded Object.\n" );

   else
      printf( "Succeeded:  %d\n", atoi( buf ) );

    return 0;
}
