/* $Id: killjvm.c,v 1.2 2001/10/31 00:34:02 eric Exp $ */

/* SUMMARY
 *
 * killjvm.c - killjvm
 *
 * The program killjvm contacts a PJVM Manager, which in turn contacts 
 * its PJVM Server, and attempts to terminate the operation of a JVM
 * in memory.  If successful, the JVM is terminated and the port at 
 * which the JVM resided is freed.
 *
 *
 * REVISION HISTORY
 * $Log: killjvm.c,v $
 * Revision 1.2  2001/10/31 00:34:02  eric
 * JVM Number doesn't require flag
 *
 * Revision 1.1  2001/10/23 21:30:02  eric
 * Initial revision
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define LINELEN 128
#define MAX_JVMS 10000
   /* Note - right now jvm_number is set to 10000, a number well
      above the allowable number of jvms, so that if the user fails
      to specify a JVM the code will fail.  This number must always
      be kept above the allowable number of JVMs. */

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - kill extant JVM.
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1 ], service[ LINELEN + 1 ], buf[ LINELEN + 1 ];
   int jvm_number = MAX_JVMS, c, s, n;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error messages */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:" ) ) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case '?': errexit( "Usage: killjvm [-h hostname] "
                            "[-s service] jvmnumber\n" );
      }
   }

   if ( optind < ( argc ) )
      jvm_number = atoi( argv[ optind ] );

   if ( jvm_number == MAX_JVMS )
      errexit( "You must specify a JVM.\n" );

   s = connectTCP( host, service );

   sprintf( buf, "kvm %d", jvm_number );
   ( void ) write( s, buf, LINELEN );

   for ( c = 0; c < LINELEN; c += n )
   {
      n = read( s, buf, LINELEN );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == 0 )
      printf( "JVM terminated normally.\n" );
   else if ( atoi( buf ) == -10000 )
      fprintf( stderr, "Invalid JVM number chosen for termination.\n" );
   else
      fprintf( stderr, "JVM terminated with code %d\n", atoi( buf ) );

   return atoi( buf );
}
