/* $Id: listclass.c,v 1.1 2001/10/23 21:30:02 eric Exp $ */

/* SUMMARY
 *
 * listclass.c - listclass
 *
 * The program listclass contacts a PJVM Manager, which contacts one or 
 * all of its registered JVMs and requests from them a list of loaded
 * classes.  If a JVM is specified with the -j option, then only the 
 * classes associated with that JVM are listed; otherwise, the Manager
 * iterates through its list of JVMs and queries each in turn.  The list
 * is returned in the format:
 *
 *      JVM [jvmnumber]
 *      [classnumber] classname
 *
 *
 * REVISION HISTORY
 * $Log: listclass.c,v $
 * Revision 1.1  2001/10/23 21:30:02  eric
 * Initial revision
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define LINELEN 128
#define BUFSIZE 4096
#define MAX_JVMS 10000 /* change with max JVM count */
#define TRUE 1
#define FALSE 0

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - list loaded classes
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1 ], service[ LINELEN + 1 ], buf[ LINELEN + 1 ],
        largebuf[ BUFSIZE + 1 ];
   int jvm_number = MAX_JVMS + 1, jvm_selected = FALSE, s, c, n, i;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error messages */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:j:" ) ) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case 'j': if ( strlen( optarg ) != 0 )
                      jvm_number = atoi( optarg );
                   break;
         case '?': errexit( "Usage: listclass [-h hostname] "
                            "[-s service] [-j JVM number]\n" );
      }
   }

   if ( jvm_number < MAX_JVMS )
      jvm_selected = TRUE;

   s = connectTCP( host, service );

   sprintf( buf, "lsc %d %d", jvm_selected, jvm_number );
   ( void ) write( s, buf, LINELEN );

   for ( c = 0; c < LINELEN; c += n )
   {
      n = read( s, buf, LINELEN );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == -10000 )
      errexit( "Invalid JVM number selected.\n" );

   else
   {
      for ( i = 0; i <= atoi( buf ); i++ )
      {
         if ( jvm_selected == FALSE )
            printf( "JVM %d\n", i );
         else
            printf( "JVM %d\n", jvm_number );

         for ( c = 0; c < BUFSIZE; c += n )
         {
            n = read( s, largebuf, BUFSIZE );
            if ( n < 0 )
               errexit( "read: %s\n", strerror( errno ) );
         }

         /* print returned buffer */

         printf( "%s\n", largebuf );
      }
   }

   return 0;
}
