/* $Id: listconstructors.c,v 1.1 2001/10/23 21:30:02 eric Exp $ */

/* SUMMARY
 *
 * listconstructors.c - listconstructors
 *
 * The program listconstructors contacts a PJVM Manager which in turn
 * contacts the specific JVM requested on the command line, and then
 * attempts to extract from the specified class a list of constructors
 * with which the class can be instantiated.  If successful, a list of
 * these constructors, along with their formats, is returned.
 *
 *
 * REVISION HISTORY
 * $Log: listconstructors.c,v $
 * Revision 1.1  2001/10/23 21:30:02  eric
 * Initial revision
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define LINELEN 128
#define BUFSIZE 4096
#define MAX_JVMS 10000 /* change with max JVM count */
#define TRUE 1
#define FALSE 0

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - list constructors for loaded class
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1], service[ LINELEN + 1 ], buf[ LINELEN + 1 ],
        largebuf[ BUFSIZE + 1 ];
   int jvm_number = MAX_JVMS + 1, class_number, class_selected = FALSE,
       s, c, n;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error messages */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:j:c:" ) ) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case 'j': if ( strlen( optarg ) != 0 )
                      jvm_number = atoi( optarg );
                   break;
         case 'c': if ( strlen( optarg ) != 0 )
                   {
                      class_selected = TRUE;
                      class_number = atoi( optarg );
                   }
                   break;
         case '?': errexit( "Usage: listconstructors [-h hostname] "
                            "[-s service] [-j JVM number] "
                            "[-c class number]\n" );
      }
   }
   
   if ( jvm_number == ( MAX_JVMS + 1 ) )
      errexit( "You must select a JVM.\n" );

   if ( class_selected == FALSE )
      errexit( "You must select a class number.\n" );

   s = connectTCP( host, service );

   sprintf( buf, "lco %d %d", jvm_number, class_number );
   ( void ) write( s, buf, LINELEN );

   for ( c = 0; c < BUFSIZE; c+= n )
   {
      n = read( s, largebuf, BUFSIZE );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( largebuf ) == -10000 )
      errexit( "Invalid JVM number selected.\n" );

   if ( atoi( largebuf ) == -20000 )
      errexit( "Invalid class number selected.\n" );

   printf( "%s\n", largebuf );

   return 0;
}
