/* $Id: listjvm.c,v 1.1 2001/10/23 21:30:02 eric Exp $ */

/* SUMMARY
 *
 * listjvm.c - listjvm
 *
 * The  program  listjvm  contacts a PJVM Manager which in turn responds
 * with a list of running JVMs available for use.  In addition, the host
 * name and port number on which that JVM's server resides is listed.
 *
 *      Output is in the format:
 *         JVM     Host                Port
 *
 *
 * REVISION HISTORY
 *
 * $Log: listjvm.c,v $
 * Revision 1.1  2001/10/23 21:30:02  eric
 * Initial revision
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define BUFSIZE 4096
#define LINELEN 128

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - list extant JVMs.
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1], service[ LINELEN + 1 ], buf[ LINELEN + 1 ],
        largebuf[ BUFSIZE + 1 ];
   int c, s, inchars;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error messages */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:" ) ) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case '?': errexit( "Usage: listjvm [-h hostname] "
                            "[-s service]\n" );
      }
   }

   s = connectTCP( host, service );

   sprintf( buf, "lsj" );
   ( void ) write( s, buf, LINELEN );

   for ( inchars = 0; inchars < LINELEN; inchars += c )
   {
      c = read( s, buf, LINELEN );
      if ( c < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == 0 )
   {
      printf( "No JVMs available.\n" );
      return 0;
   }

   for ( inchars = 0; inchars < BUFSIZE; inchars += c )
   {
      c = read( s, largebuf, BUFSIZE );
      if ( c < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }
 
   printf( "%s", largebuf );

   return 0;
}
