/* $Id: listmethods.c,v 1.2 2001/11/14 18:10:26 eric Exp $ */

/* SUMMARY
 *
 * listmethods.c - listmethods
 *
 * The program listmethods contacts a PJVM Manager which in turn
 * contacts the specific JVM requested on the command line, and then
 * attempts to extract from the specified class a list of methods
 * contained within the class.  If successful, a list of these methods,
 * along with their formats, is returned.
 *
 *
 * REVISION HISTORY
 * $Log: listmethods.c,v $
 * Revision 1.2  2001/11/14 18:10:26  eric
 * Corrected options to make JVM number and class number requirements and to allow specification of delcared methods
 *
 * Revision 1.1  2001/11/04 05:28:26  eric
 * Initial revision
 *
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define LINELEN 128
#define BUFSIZE 4096
#define MAX_JVMS 10000 /* change with max JVM count */
#define TRUE 1
#define FALSE 0

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - list methods for loaded class
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1], service[ LINELEN + 1 ], buf[ LINELEN + 1 ],
        largebuf[ BUFSIZE + 1 ];
   int jvm_number = MAX_JVMS + 1, class_number, class_selected = FALSE,
       s, c, n, declared_only = FALSE;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error messages */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:j:c:d" ) ) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case 'j': if ( strlen( optarg ) != 0 )
                      jvm_number = atoi( optarg );
                   break;
         case 'c': if ( strlen( optarg ) != 0 )
                   {
                      class_selected = TRUE;
                      class_number = atoi( optarg );
                   }
                   break;
         case 'd': declared_only = TRUE;
                   break;
         case '?': errexit( "Usage: listmethods [-h hostname] "
                            "[-s service] -j JVM number "
                            "-c class number -d\n" );
      }
   }
   
   if ( jvm_number == ( MAX_JVMS + 1 ) )
      errexit( "You must select a JVM.\n" );

   if ( class_selected == FALSE )
      errexit( "You must select a class number.\n" );

   s = connectTCP( host, service );

   sprintf( buf, "lme %d %d %d", declared_only, jvm_number, 
            class_number );

   ( void ) write( s, buf, LINELEN );

   for ( c = 0; c < BUFSIZE; c+= n )
   {
      n = read( s, largebuf, BUFSIZE );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( largebuf ) == -10000 )
      errexit( "Invalid JVM number selected.\n" );

   if ( atoi( largebuf ) == -20000 )
      errexit( "Invalid class number selected.\n" );

   printf( "%s\n", largebuf );

   return 0;
}
