/* $Id: loadclass.c,v 1.2 2001/10/31 00:34:17 eric Exp $ */

/* SUMMARY
 *
 * loadclass.c - loadclass
 *
 * The program loadclass attempts to load an existing Java .class file 
 * into a running JVM's memory.  If the file exists and is a valid
 * .class file, the JVM specified will contain a copy of that file in 
 * memory, ready to be instantiated or to have its static methods or
 * members accessed.
 *
 *
 * REVISION HISTORY
 *
 * $Log: loadclass.c,v $
 * Revision 1.2  2001/10/31 00:34:17  eric
 * JVM number doesn't require flag
 *
 * Revision 1.1  2001/10/23 21:30:02  eric
 * Initial revision
 *
 */

#define _USE_BSD
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <netinet/in.h>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "errexit.h"
#include "connectTCP.h"

#define LINELEN 128
#define MAX_JVMS 10000 /* change with max JVM count */
#define REMOTE 0
#define LOCAL 1
#define UNDEFINED 5

extern int errno;

/*  Function main()
 *  --------------------------------------------------------------------
 *
 *    TCP client for PJVM service - load class
 *
 */

int main( int argc, char *argv[] )
{
   char host[ LINELEN + 1 ], service[ LINELEN + 1 ], buf[ LINELEN + 1 ],
        classname[ LINELEN + 1 ];
   int jvm_number = MAX_JVMS, c, s, n, source = UNDEFINED;

   strcpy( host, "localhost" );
   strcpy( service, "pjvmmanager" );

   /* disable getopt() error message */
   opterr = 0;

   while ( ( c = getopt( argc, argv, "h:s:r:l:" ) ) != -1 )
   {
      switch ( c )
      {
         case 'h': if ( strlen( optarg ) != 0 )
                      strncpy( host, optarg, LINELEN );
                   break;
         case 's': if ( strlen( optarg ) != 0 )
                      strncpy( service, optarg, LINELEN );
                   break;
         case 'r': if ( strlen( optarg ) != 0 )
                   {
                      strncpy( classname, optarg, LINELEN );
                      source = REMOTE;
                   }
                   break;
         case 'l': if ( strlen( optarg ) != 0 )
                   {
                      strncpy( classname, optarg, LINELEN );
                      source = LOCAL;
                   }
                   break;
         case '?': errexit( "Usage: loadclass [-h hostname] "
                            "[-s service] "
                            "-r remote |-l local filename "
                            "jvmnumber\n" );
      }
   }

   if ( optind < argc )
      jvm_number = atoi( argv[ optind ] );

   if ( jvm_number == MAX_JVMS )
      errexit( "You must specify a JVM.\n" );

   if ( source == UNDEFINED )
      errexit( "You must specify a source and filename.\n" );

   s = connectTCP( host, service );

   sprintf( buf, "ldc %d %d %s", jvm_number, source, classname );
   ( void ) write( s, buf, LINELEN );

   for ( c = 0; c < LINELEN; c += n )
   {
      n = read( s, buf, LINELEN );
      if ( n < 0 )
         errexit( "read: %s\n", strerror( errno ) );
   }

   if ( atoi( buf ) == -10000 )
      errexit( "Invalid JVM number.\n" );

   else if ( atoi( buf ) == -1 )
      errexit( "Class did not load - check class name.\n" );

   else if ( atoi( buf ) == 1 )
      printf( "Class loaded successfully.\n" );
   else
      errexit( "Unspecified error.\n" );

   return 0;
}
