/* $Id: strtok2.h,v 1.1 2001/10/23 21:30:02 eric Exp $ */

/* SYNOPSIS
 *
 * strtok2.h - strtok2 header
 *
 * The strtok2() function splits the string pointed to by the buf 
 * parameter into a sequence of tokens, each of which is delimited by a
 * byte equal to one of the bytes in the delim_list parameter.  That 
 * byte is then copied into the delim_storage variable.
 *
 * strtok2() can be called repeatedly to extract all of the tokens in 
 * the string.  When the final token is reached, or if there are no
 * tokens to return, strtok2() will return a NULL pointer.
 *
 *
 * REVISION HISTORY
 *
 * $Log: strtok2.h,v $
 * Revision 1.1  2001/10/23 21:30:02  eric
 * Initial revision
 *
 */

#ifndef STRTOK2_H
#define STRTOK2_H

/*  Function strtok2()
 *  --------------------------------------------------------------------
 *
 *    strtok2() aims to be a threadsafe version of strtok(). 
 *    If there are multiple trailing delimiters, this implementation
 *    will return only the first one, and will then ignore the next
 *    group of delimiters.
 *
 *    PARAMETERS:
 *      buf           - the string to tokenize
 *      delim_storage - location in which to store delimiter
 *      delim_list    - list of delimiters
 *
 *    RETURNS
 *      char *        - a single string extracted from buffer
 *
 */

char *strtok2( char **buf, char *delim_storage, char *delim_list );

#endif
